/**
 * \file: util_string.c
 *
 * \version: $Id: util_string.c,v 1.4 2010/09/15 11:13:37 ykumazaki Exp $
 *
 * Implementation of some string operations.
 *
 * \component: platform/utility
 *
 * \author: Dirk Langner
 *
 * \copyright: (c) 2003 ? 2004 ADIT Corporation
 */
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <util_lib.h>


unsigned int getDigits(unsigned int n)
{
    unsigned int digits = (n == 0) ? (unsigned int)1 : (unsigned int)0;

    while(n)
    {
        digits++;
        n/=10;
    } return digits;
}

/* creates text version of given integer,
   and stores it in array s                 */
#ifndef BUILDENV_TSIM
unsigned char* itoa(unsigned int n, unsigned char *s)
#else
unsigned char* UTIL_itoa(unsigned int n, unsigned char *s)
#endif
{
    unsigned int value = 0;  // holds extracted digit in binary
    unsigned char *t = s;    // save given pointer
    t += getDigits(n);// + neg; /* pos to start reverse fill */
    *t-- = 0;   /* add terminator */
    *t = '0';   /* text for zero value (not handled below) */

    while(n)
    {
        value = n % 10;     // extract digit
        *t-- = (unsigned char)value + '0'; // convert to text
        n /= 10;              // next digit
    }

    return s;       // return pointer to filled string
}


/* creates integer value of a given hexadecimal string and stores it into
   p_hex_int.
  */
EXPORT U8* UTIL_axtoi(U8* p_hex_str, U8* p_hex_int, U32 size) 
{
    /* position in string */
    U32 n = 0;
    U32 p = 0;
    U8 m = 4;
    U8 *hex_val = p_hex_int;
    /** parameter check */
    if (p_hex_str == NULL || p_hex_int == NULL)
    {
        return NULL;
    }
    else
    {
        if (size <= 0)
        {
            return NULL;
        }
    }
    p_hex_int[p] = 0x00;
    while ((n < size) && (NULL != hex_val))
    {
        /* test for 0-9 */
        if (p_hex_str[n] > 0x29 && p_hex_str[n] < 0x3a )
        {
            p_hex_int[p] |= (p_hex_str[n] & 0x0f) << m;
        }
        else 
        {
            /* test for  a-f */
            if ((p_hex_str[n] >='a' && p_hex_str[n] <= 'f') ||
                (p_hex_str[n] >='A' && p_hex_str[n] <= 'F'))
            {
                p_hex_int[p] |= ((p_hex_str[n] & 0x0f) + 9) << m;
            }
            else
            {
                hex_val = NULL;
            }
        }
        n++;
        m ^= 4;
        if (m == 4)
        {
            p++;
            p_hex_int[p] = 0x00;   
        }
        
    }
    return hex_val;
}


/*
 * UTIL_tokenizer divides a string by delimiter characters
 */
int UTIL_tokenizer(const char* p_str,
				   char* p_token[],
				   int size,
				   int count,
				   const char* p_delimiter,
				   BOOL add_delimiter)
{
	const char*	p_read = p_str;
	char		chr;
	int			tcount = 0;
	int			chcnt  = 0;
	char*		p_tkn = NULL;

	/*
	 * Parameter check
	 */
	if((size <= 0) || (count <= 0)) {
		return	-1;
	}
	if((p_str == NULL) || (p_token == NULL) || (p_delimiter == NULL)) {
		return	-1;
	}

    p_tkn = p_token[tcount];
	/*
	 * Analyzing
	 */
	do {
		chr = *p_read++;
		if(strchr(p_delimiter, chr) == NULL) {
			p_tkn[chcnt++] = chr;
			if(chcnt >= size) {
				p_tkn[size - 1] = '\0';
				while((chr = *p_read++) != '\0') {
					if(strchr(p_delimiter, chr) != NULL) {
						break;
					}
				}
				if(chr == '\0')
				{
                    tcount++;
                    break;
                }
				chcnt = size - 1;
				p_read--;			/* Back to previous */
			}
		} else {
			/*
			 * Read character is delimiter
			 */
			p_tkn[chcnt] = '\0';
			if(chcnt > 0) {
				p_tkn = p_token[++tcount];
			}

			if(tcount < count) {
				if(add_delimiter && (chr != '\0')) {
					*p_tkn++ = chr;
					*p_tkn   = '\0';
					p_tkn = p_token[++tcount];
				}
			}
			chcnt = 0;
		}
		if(tcount >= count) {
			break;
		}
	} while(chr != '\0');

	return	tcount;
}


/*
 * Storing compare by ignore case.
 */
int	UTIL_stricmp(const char* left, const char* right)
{
	int		i = 0;
	int		val;

	while(left[i] != '\0') {
		if(right[i] == '\0') {
			return	1;
		}
		val = toupper(left[i]) - toupper(right[i]);
		if(val != 0) {
			return	val;
		}
		i++;
	}

	if(right[i] == '\0') {
		return	0;
	}

	return	-1;
}
